﻿using Helper;
using Newtonsoft.Json.Linq;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using ZSMusic.IDAL;
using ZSMusic.Model;

namespace ZSMusic.DAL.Platforms
{
    public class qq : IMusic
    {
        public List<Music> Search(string word, int page, int num)
        {
            List<Music> list = new List<Music>();
            string src = HttpHelper.Get(string.Format(
            "https://www.ctrlqq.com/y/api.php?callback=jQuery11130182920795747622_1585018563804&types=search&count={0}&source=tencent&pages={1}&name={2}"
            , num, page, word));

            string[] infos = StringEx.GetMiddleTextMultiple(src, "{\"", "},");
            foreach (string i in infos)
            {
                Music s = new Music();
                s.Id = StringEx.GetMiddleText(i, "id\":\"", "\",\"name");
                s.Name = StringEx.GetMiddleText(i, "name\":\"", "\",\"artist");
                s.Album = StringEx.GetMiddleText(i, "album\":\"", "\",\"pic_id");
                s.Artist = StringEx.GetMiddleText(i, "artist\":[\"", "\"],\"album");
                s.AlbumId = StringEx.GetMiddleText(i, "pic_id\":\"", "\",\"url_id");
                s.Source = "qq";
                s.ToString();
                list.Add(s);
            }
            return list;
        }

        public List<Music> SearchCollection(string id)
        {
            List<Music> list = new List<Music>();
            string src = HttpHelper.Get(
                string.Format("http://c.y.qq.com/qzone/fcg-bin/fcg_ucc_getcdinfo_byids_cp.fcg?type=1&utf8=1&disstid={0}&format=json", id),
                string.Format("https://y.qq.com/n/yqq/playlist/{0}.html", id));
            string json = StringEx.GetMiddleText(src, "\"songlist\":", ",\"visitnum");
            JArray array = JArray.Parse(json);
            foreach (var item in array)
            {
                Music m = new Music();
                m.Id = item["songmid"].ToString();
                m.Name = item["songname"].ToString();
                JArray art = JArray.Parse(item["singer"].ToString());
                m.Artist = "";
                foreach (var i in art)
                {
                    m.Artist += i["name"];
                    m.Artist += ',';
                }
                m.Artist = m.Artist.TrimEnd(',');
                m.Album = item["albumname"].ToString();
                m.AlbumId = item["albummid"].ToString();
                //m.PicId = m.Id;
                m.Source = "qq";
                list.Add(m);
            }
            return list;
        }

        public List<Music> SearchAlbum(string id)
        {
            throw new NotImplementedException();
        }

        public bool GetData(Music m, string type = "all")
        {
            switch (type)
            {
                case "all":
                    GetPic(m);
                    GetLrc(m);
                    return GetUrl(m);
                case "url":
                    return GetUrl(m);
                case "pic":
                    return GetPic(m);
                case "lrc":
                    return GetLrc(m);
                default:
                    throw new NotImplementedException();
            }
        }

        public bool GetUrl(Music m)
        {
            string Src = StringEx.GetMiddleText(HttpHelper.Get(string.Format(
    "http://music.postgraduate.top/api.php?callback=jQuery11130182920795747622_1585018563804&types=url&id={0}&source=tencent"
    , m.Id), "https://music.postgraduate.top/"), "jQuery11130182920795747622_1585018563804(", ")");//.Trim(new char[]{'(',')'});
            m.Url = StringEx.ExactJson(Src, "url").Replace("\\", "");
            return HttpHelper.CheckUri(m.Url);
        }

        public bool GetLrc(Music m)
        {
            string Lrcsrc = StringEx.GetMiddleText(HttpHelper.Get(string.Format(
     "https://www.hackhp.com/demo/MKOnlineMusicPlayer/api.php?callback=jQuery11130182920795747622_1585018563804&types=lyric&id={0}&source=tencent"
     , m.Id)), "jQuery11130182920795747622_1585018563804(", "})") + "}";
            m.Lrc = StringEx.ExactJson(Lrcsrc, "lyric").Trim().Replace("\\n", "\n").Replace("\\r", "");
            return !string.IsNullOrWhiteSpace(m.Lrc);
        }

        public bool GetPic(Music m)
        {
            string picsrc = StringEx.GetMiddleText(HttpHelper.Get(string.Format(
    "https://www.hackhp.com/demo/MKOnlineMusicPlayer/api.php?callback=jQuery11130182920795747622_1585018563804&types=pic&id={0}&source=tencent"
    , m.AlbumId)), "jQuery11130182920795747622_1585018563804(", ")");
            m.PicUrl = StringEx.ExactJson(picsrc, "url").Replace("\\", "");
            return HttpHelper.CheckUri(m.PicUrl);
        }
    }
}
